/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.util;

import com.mojang.math.Vector3f;
import java.util.Arrays;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;

public final class MathUtils {
    private MathUtils() {
    }

    public static Vec3 vectorFromPos(Vec3i pos) {
        return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public static Vec3 shiftToCenter(Vec3 pos) {
        return new Vec3(pos.f_82479_ + 0.5, pos.f_82480_ + 0.5, pos.f_82481_ + 0.5);
    }

    public static Vec3 shiftToCenter(Vec3i pos) {
        return new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
    }

    public static int flipCircle(Number degree) {
        return 360 - degree.intValue();
    }

    public static float singleRotation(Number degree) {
        return Math.abs(degree.floatValue()) % 360.0f;
    }

    public static Vector3f[][] getHorizontalVectors(Vector3f ... north) {
        Vector3f[] south = (Vector3f[])Arrays.stream(north).map(MathUtils::getOppositeVector).toArray(Vector3f[]::new);
        Vector3f[] east = (Vector3f[])Arrays.stream(north).map(MathUtils::getNeighborVector).toArray(Vector3f[]::new);
        Vector3f[] west = (Vector3f[])Arrays.stream(east).map(MathUtils::getOppositeVector).toArray(Vector3f[]::new);
        return new Vector3f[][]{north, south, west, east};
    }

    public static float modifier(float current, float max, float fallback) {
        return max == 0.0f ? fallback : current / max;
    }

    private static Vector3f getOppositeVector(Vector3f vector) {
        return new Vector3f(16.0f - vector.m_122239_(), vector.m_122260_(), 16.0f - vector.m_122269_());
    }

    private static Vector3f getNeighborVector(Vector3f vector1) {
        Vector3f vector2 = MathUtils.getOppositeVector(vector1);
        return new Vector3f(vector2.m_122269_(), vector1.m_122260_(), vector1.m_122239_());
    }
}

